<?php /* user1.php */ ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>User1</title>
  <style>canvas { border:1px solid #333; background:gray }</style>
</head>
<body>
<canvas id="gameCanvas" width="1000" height="600"></canvas>
<script>
const canvas=document.getElementById("gameCanvas"),ctx=canvas.getContext("2d");
const img=new Image(); img.src="pc1.gif";

let p1, p2;
let target={x:100,y:100},mousePos={x:100,y:100},speed=2;
let canShoot=true;

/* --- Input --- */
canvas.addEventListener("mousemove",e=>{
  const r=canvas.getBoundingClientRect();
  mousePos={x:e.clientX-r.left,y:e.clientY-r.top};
});
canvas.addEventListener("click",e=>{
  const r=canvas.getBoundingClientRect();
  target={x:e.clientX-r.left,y:e.clientY-r.top};
});
document.addEventListener("keydown",e=>{
  if((e.key==="a"||e.key==="A")&&canShoot){
    const dx=mousePos.x-p1.x,dy=mousePos.y-p1.y,d=Math.hypot(dx,dy);
    if(d>0.1){
      p1.bullets.push({x:p1.x,y:p1.y,vx:dx/d*6,vy:dy/d*6,radius:6,trail:[]});
      canShoot=false;
    }
  }
  if(e.key==="b"||e.key==="B"){ p1.shield=1; }
});
document.addEventListener("keyup",e=>{
  if(e.key==="b"||e.key==="B"){ p1.shield=0; }
});

/* --- Update --- */
function updateLocal(){
  const dx=target.x-p1.x,dy=target.y-p1.y,d=Math.hypot(dx,dy);
  if(d>1){ p1.x+=dx/d*speed; p1.y+=dy/d*speed; p1.direction=dx<0?"left":"right"; }
  p1.bullets.forEach(b=>{
    b.x+=b.vx; b.y+=b.vy;
    b.trail.push({x:b.x,y:b.y,alpha:1,radius:Math.random()*4+2});
    b.trail.forEach(p=>p.alpha-=0.05);
    b.trail=b.trail.filter(p=>p.alpha>0);
  });
  p1.bullets=p1.bullets.filter(b=>b.x>-20&&b.x<canvas.width+20&&b.y>-20&&b.y<canvas.height+20);
  if(p1.bullets.length===0) canShoot=true;
}

/* --- Render --- */
function drawPlayer(pl){
  if(pl.shield===1){
    const radius=40;
    const g=ctx.createRadialGradient(pl.x,pl.y,10,pl.x,pl.y,radius);
    g.addColorStop(0,"rgba(0,150,255,0.6)");
    g.addColorStop(1,"rgba(0,0,255,0)");
    ctx.fillStyle=g;
    ctx.beginPath(); ctx.arc(pl.x,pl.y,radius,0,Math.PI*2); ctx.fill();
  }

  ctx.save();
  if(pl.direction === "left"){
    // balik gambar ke kiri
    ctx.translate(pl.x+25, pl.y-25);
    ctx.scale(-1,1);
    ctx.drawImage(img,0,0,50,50);
  } else {
    // default ke kanan
    ctx.translate(pl.x-25, pl.y-25);
    ctx.drawImage(img,0,0,50,50);
  }
  ctx.restore();
}


function drawBullets(arr){
  arr.forEach(b=>{
    (b.trail||[]).forEach(p=>{
      const g=ctx.createRadialGradient(p.x,p.y,0,p.x,p.y,p.radius);
      g.addColorStop(0,`rgba(255,200,0,${p.alpha})`);
      g.addColorStop(1,`rgba(255,0,0,0)`);
      ctx.fillStyle=g;
      ctx.beginPath(); ctx.arc(p.x,p.y,p.radius,0,Math.PI*2); ctx.fill();
    });
    ctx.fillStyle="yellow"; ctx.beginPath(); ctx.arc(b.x,b.y,b.radius,0,Math.PI*2); ctx.fill();
  });
}
function draw(){
  ctx.clearRect(0,0,canvas.width,canvas.height);
  drawPlayer(p1); drawBullets(p1.bullets);
  drawPlayer(p2); drawBullets(p2.bullets);
}

/* --- Sync DB --- */
function syncState(){
  fetch("update.php",{
    method:"POST",
    headers:{"Content-Type":"application/x-www-form-urlencoded"},
    body:"who=player1&state="+encodeURIComponent(JSON.stringify(p1))
  });
}
function fetchState(){
  fetch("getstate.php").then(r=>r.json()).then(d=>{p2=d.player2;});
}

/* --- Loop --- */
function loop(){ updateLocal(); draw(); requestAnimationFrame(loop); }

/* --- Init --- */
img.onload=()=>{
  fetch("getstate.php").then(r=>r.json()).then(d=>{
    p1=d.player1;
    p2=d.player2;
    target={x:p1.x,y:p1.y};
    loop();
    setInterval(syncState,150);
    setInterval(fetchState,150);
  });
};
</script>
</body>
</html>
