<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Move & Flip Icon + Fire Bullet</title>
  <style>
    canvas { border:1px solid #333; background:gray }
  </style>
</head>
<body>
<canvas id="gameCanvas" width="1000" height="600"></canvas>

<script>
const canvas = document.getElementById("gameCanvas");
const ctx = canvas.getContext("2d");

const img = new Image();
img.src = "pc1.gif";

let pos = { x: 100, y: 100 };
let target = { x: 100, y: 100 };
let speed = 2;
let direction = "right";
let bullets = [];
let mousePos = { x: 100, y: 100 };

canvas.addEventListener("mousemove", (e) => {
  const rect = canvas.getBoundingClientRect();
  mousePos.x = e.clientX - rect.left;
  mousePos.y = e.clientY - rect.top;
});

canvas.addEventListener("click", (e) => {
  const rect = canvas.getBoundingClientRect();
  target.x = e.clientX - rect.left;
  target.y = e.clientY - rect.top;
});

document.addEventListener("keydown", (e) => {
  if (e.key === "a" || e.key === "A") {
    const dx = mousePos.x - pos.x;
    const dy = mousePos.y - pos.y;
    const dist = Math.sqrt(dx*dx + dy*dy);
    const bulletSpeed = 6;

    bullets.push({
      x: pos.x,
      y: pos.y,
      vx: (dx / dist) * bulletSpeed,
      vy: (dy / dist) * bulletSpeed,
      radius: 6,
      trail: [] // array partikel api
    });
  }
});

function update() {
  const dx = target.x - pos.x;
  const dy = target.y - pos.y;
  const dist = Math.sqrt(dx*dx + dy*dy);

  if (dist > 1) {
    pos.x += (dx / dist) * speed;
    pos.y += (dy / dist) * speed;

    if (dx < 0) direction = "left";
    else if (dx > 0) direction = "right";
  }

  bullets.forEach(b => {
    b.x += b.vx;
    b.y += b.vy;

    // tambahkan partikel trail
    b.trail.push({
      x: b.x,
      y: b.y,
      alpha: 1.0,
      radius: Math.random() * 4 + 2
    });

    // kurangi alpha partikel
    b.trail.forEach(p => p.alpha -= 0.05);

    // buang partikel yang sudah hilang
    b.trail = b.trail.filter(p => p.alpha > 0);
  });

  bullets = bullets.filter(b =>
    b.x > 0 && b.x < canvas.width && b.y > 0 && b.y < canvas.height
  );
}

function draw() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.save();

  if (direction === "left") {
    ctx.translate(pos.x + 25, pos.y - 25);
    ctx.scale(-1, 1);
    ctx.drawImage(img, 0, 0, 50, 50);
  } else {
    ctx.translate(pos.x - 25, pos.y - 25);
    ctx.drawImage(img, 0, 0, 50, 50);
  }

  ctx.restore();

  // gambar peluru + trail
  bullets.forEach(b => {
    // trail partikel
    b.trail.forEach(p => {
      const gradient = ctx.createRadialGradient(p.x, p.y, 0, p.x, p.y, p.radius);
      gradient.addColorStop(0, `rgba(255,200,0,${p.alpha})`);
      gradient.addColorStop(1, `rgba(255,0,0,0)`);
      ctx.fillStyle = gradient;
      ctx.beginPath();
      ctx.arc(p.x, p.y, p.radius, 0, Math.PI * 2);
      ctx.fill();
    });

    // inti peluru
    ctx.fillStyle = "yellow";
    ctx.beginPath();
    ctx.arc(b.x, b.y, b.radius, 0, Math.PI * 2);
    ctx.fill();
  });
}

function loop() {
  update();
  draw();
  requestAnimationFrame(loop);
}

img.onload = () => loop();
</script>
</body>
</html>
